<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van COMT_IN999999NL - Log Response</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>
    <include href="coreschematron/xml.sch"/>
    <include href="coreschematron/attentionLine.sch"/>

    <include href="coreschematron/transmission-wrapper.sch"/>
    <include href="coreschematron/controlAct-wrapper.sch"/>

    <include href="coreschematron/COCT_MT090300.sch"/>

    <pattern is-a="attentionLine" id="COMT_IN999999NL-attentionLine">
        <param name="messagePatientId" value="hl7:attentionLine/hl7:value"/>
        <param name="attentionLineOptional" value="'true'"/>
    </pattern>
    
    <pattern is-a="transmission-wrapper" id="COMT_IN999999NL-wrapper">
        <param name="element" value="hl7:COMT_IN999999NL"/>
    </pattern>
    
    <pattern is-a="controlAct-wrapper" id="COMT_IN999999NL-controlAct">
        <param name="element" value="hl7:COMT_IN999999NL/hl7:ControlActProcess"/>
    </pattern>
    
    <pattern>
        <!-- profileId -->
        <rule context="hl7:COMT_IN999999NL/hl7:profileId">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"
                >In de transmission wrapper moet het element profileId worden gevuld met de waarde '810'</assert>
        </rule>
        <rule context="hl7:COMT_IN999999NL/hl7:acceptAckCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='NE'">In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'NE'.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <rule context="hl7:informEvent/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="@nullFlavor or (@root and @extension)">Id element mist root
                of extension</assert>
        </rule>
        <rule context="hl7:informEvent/hl7:code">
            <extends rule="CV"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.1.6'">codeSystem van de code
                moet '2.16.840.1.113883.1.6' (InteractionId) zijn</assert>
        </rule>
        <rule context="hl7:informEvent/hl7:effectiveTime">
            <extends rule="TS"/>
            <assert role="error" test="@value or @nullFlavor='NA'">Als effectiveTime niet is ingevuld, dan moet de
                nullFlavor de waarde 'NA' bevatten.</assert>
        </rule>

        <!-- controle op X uitgecommentarieerd omdat we deze alsnog willen toevoegen aan AORTA 2011 middels een RFC -->
        <rule context="hl7:informEvent/hl7:availabilityTime">
            <extends rule="TS"/>
            <!--            <report role="warning" test="."
                >het advies is om availabilityTime niet te gebruiken.</report>
-->
        </rule>

        <rule context="hl7:subject/hl7:informEvent/hl7:subjectOf">
            <assert role="error" test="not(.)">subjectOf is niet van toepassing voor initiële
                berichten</assert>
        </rule>

        <rule context="hl7:sequel/hl7:informEvent">
            <assert role="error" test="hl7:subjectOf">subjectOf is verplicht voor
                antwoordberichten</assert>
            <assert role="error" test="not(hl7:sequel)">De actrelatie sequel mag tot slechts één
                niveau diep worden gebruikt</assert>
        </rule>


        <rule context="hl7:sequel/hl7:informEvent/hl7:subjectOf/hl7:acknowledgement/hl7:code">
            <extends rule="CD"/>
            <assert role="error" test="@codeSystem='2.16.840.1.113883.5.18'">@codeSystem moet waarde
                '2.16.840.1.113883.5.18' bevatten.</assert>
        </rule>
        
        <rule
            context="hl7:sequel/hl7:informEvent/hl7:subjectOf/hl7:acknowledgement/hl7:componentOf/hl7:detectedIssue/hl7:code">
            <extends rule="CD"/>
            <assert test="not(./@nullFlavor)">detectedIssue/code is verplicht en mag geen nullFlavor bevatten.</assert>
        </rule>
        
        <rule
            context="hl7:sequel/hl7:informEvent/hl7:subjectOf/hl7:acknowledgement/hl7:componentOf/hl7:detectedIssue/*">
            <assert role="error" test="local-name(.)='code' or local-name(.)='text'"
                >in detectedIssue mogen alleen de elementen 'code' en/of 'text' opgenomen worden.</assert>
        </rule>
    </pattern>

    <pattern>
        <rule context="hl7:actEvent">
            <assert role="error" test="not(@classCode) or @classCode='ACT'">@classCode moet indien
                aanwezig verplicht ACT bevatten. Op dit moment wordt de correcte classCode nog niet
                gelogd of herleid op basis van interactie-id dus kan deze ook niet worden
                opgeleverd.</assert>
        </rule>
    </pattern>

    <pattern is-a="COCT_MT090300" id="COMT_IN999999NL-COCT_MT090300">
        <param name="element" value="hl7:informEvent/hl7:*/hl7:assignedDevice"/>
    </pattern>

</schema>
